package fr.asip.cps3.exemple.modele.resultats;

import fr.asip.cps3.exemple.modele.traitements.util.TraitementsUtil;

/**
 * Classe reprsentant le rsultat de 3 oprations sucessives
 */
public class ResultatTriple extends ResultatDouble {

	/**
	 * Troisime code retour PKCS#11 
	 */
	protected long codeRetour3;

	/**
	 * Description de la troisime opration  l'origine du rsultat
	 */
	protected String operation3;
	
	/**
	 * Constructeur
	 * @param operation1 Description de la premire opration
	 * @param operation2 Description de la deuxime opration
	 * @param operation3 Description de la troisime opration
	 */
	public ResultatTriple(String operation1, String operation2, String operation3){
		super(operation1, operation2);
		this.codeRetour3 = 0L;
		this.operation3 = operation3;
	}

	/**
	 * Accesseur
	 * @return operation3 Description de la troisime opration  l'origine du rsultat
	 */
	public String getOperation3() {
		return operation3;
	}

	/**
	 * Ajoute du texte  la description de la troisime opration
	 * @param texte Texte  ajouter  la description de la troisime opration
	 */
	public void appendOperation3(String texte) {
		this.operation3 += texte;
	}
	
	/**
	 * Accesseur
	 * @return codeRetour3 Troisime code retour PKCS#11
	 */
	public String getCodeRetour3() {
		return TraitementsUtil.retranscritCodeRetour(codeRetour3);
	}

	/**
	 * Mutateur
	 * @param codeRetour2 Troisime code retour PKCS#11
	 */
	public void setCodeRetour3(long codeRetour3) {
		this.codeRetour3 = codeRetour3;
	}

}
